/*
 * Decompiled with CFR 0.152.
 */
package com.blamejared.crafttweaker.api.fluid;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.bracket.CommandStringDisplayable;
import com.blamejared.crafttweaker.api.data.MapData;
import com.blamejared.crafttweaker.api.fluid.CTFluidIngredient;
import com.blamejared.crafttweaker.platform.Services;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="crafttweaker.api.fluid.IFluidStack")
@Document(value="forge/api/fluid/IFluidStack")
public interface IFluidStack
extends CommandStringDisplayable {
    @ZenCodeType.Getter(value="registryName")
    default public ResourceLocation getRegistryName() {
        return Services.REGISTRY.getRegistryKey(this.getFluid());
    }

    @ZenCodeType.Method
    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.CONTAINS)
    default public boolean containsOther(IFluidStack other) {
        return this.getInternal().containsFluid(other.getInternal());
    }

    @ZenCodeType.Getter(value="empty")
    default public boolean isEmpty() {
        return this.getInternal().isEmpty();
    }

    @ZenCodeType.Getter(value="amount")
    default public int getAmount() {
        return this.getInternal().getAmount();
    }

    @ZenCodeType.Method
    public IFluidStack setAmount(int var1);

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.MUL)
    public IFluidStack multiply(int var1);

    @ZenCodeType.Method
    public IFluidStack mutable();

    @ZenCodeType.Method
    public IFluidStack asImmutable();

    @ZenCodeType.Method
    @ZenCodeType.Getter(value="isImmutable")
    public boolean isImmutable();

    @ZenCodeType.Method
    public IFluidStack copy();

    @ZenCodeType.Getter(value="fluid")
    @ZenCodeType.Caster(implicit=true)
    public Fluid getFluid();

    @ZenCodeType.Getter(value="tag")
    @ZenCodeType.Method
    public MapData getTag();

    @ZenCodeType.Method
    public IFluidStack withTag(@ZenCodeType.Nullable MapData var1);

    @ZenCodeType.Getter(value="hasTag")
    default public boolean hasTag() {
        return this.getInternal().hasTag();
    }

    public FluidStack getInternal();

    public FluidStack getImmutableInternal();

    @ZenCodeType.Caster(implicit=true)
    default public CTFluidIngredient asFluidIngredient() {
        return new CTFluidIngredient.FluidStackIngredient(this);
    }

    @ZenCodeType.Operator(value=ZenCodeType.OperatorType.OR)
    default public CTFluidIngredient asList(CTFluidIngredient other) {
        ArrayList<CTFluidIngredient> elements = new ArrayList<CTFluidIngredient>();
        elements.add(this.asFluidIngredient());
        elements.add(other);
        return new CTFluidIngredient.CompoundFluidIngredient(elements);
    }
}

